/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include "InputPacket.h"
#include "RpcLogger.h"

#include <atomic>
#include <chrono>
#include <cstdint>

class Transport
{
public:
	Transport() = default;
	virtual ~Transport() = default;

protected:
	std::atomic<bool> _active = false;

public:
	RpcLogger _Logger;
	virtual bool Run() = 0;
	virtual std::unique_ptr<InputPacket> Read(std::uint32_t id, std::chrono::milliseconds timeoutMs) = 0;
	virtual void checkActive() const = 0;
	virtual bool IsConnected() const = 0;
	virtual void StopRunning() noexcept = 0;
};
